﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.OptionSets;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{

    
    public class MapToGetConsultsRequestStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            //TODO If this is a home/mobile appointment, then skip this step since there is no patient side
            state.PatEcRequest = new GetConsultsforPatientMapper().mapGetConsultRequest(state, Side.Patient);
            var siteNum = state.PatEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqpatientInfo.mcs_localSiteId;
            state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy);
        }
    }
}


//Response
//<? xml version = "1.0" ?>
//< VIMTVIAEMRgcfpgetConsultsForPatientResponse xmlns:xsi= "http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd= "http://www.w3.org/2001/XMLSchema" >
//  < MessageId > 0a551457-fa95-4a5c-8398-9a026e6343da</MessageId>
//  <VIMTVIAEMRgcfptaggedConsultArraysInfo>
//    <mcs_count>1</mcs_count>
//    <mcs_countSpecified>true</mcs_countSpecified>
//    <VIMTVIAEMRgcfparraysInfo>
//      <VIMTVIAEMRgcfparraysMultipleResponse>
//        <mcs_tag>516</mcs_tag>
//        <mcs_count>91</mcs_count>
//        <mcs_countSpecified>true</mcs_countSpecified>
//        <VIMTVIAEMRgcfpconsultsInfo>
//          <VIMTVIAEMRgcfpconsultsMultipleResponse>
//            <mcs_title>COLONOSCOPY CP COLONOSCOPY Proc</mcs_title>
//            <mcs_id>480151</mcs_id>
//            <mcs_timestamp>20110209.072223</mcs_timestamp>
//            <mcs_status>Complete</mcs_status>
//            <mcs_text>Current PC Provider:   CHALMERS, BONITA Current PC Team:       TEAM CHY 4 Current Pat. Status:   Outpatient Primary Eligibility:   NSC(VERIFIED) Patient Type:          NSC VETERAN OEF/OIF:               NO Order Information To Service:            CP COLONOSCOPY From Service:          CHY ENDO PROCEDURE Requesting Provider:   CHALMERS,BONITA Service is to be rendered on an OUTPATIENT basis Place:                 Consultant's choice Urgency:               Routine Clinically Ind. Date:   Orderable Item:        COLONOSCOPY Procedure:             COLONOSCOPY Clinical Procedure:    COLONOSCOPY Reason For Request: (Do not use this to order a Colonoscopy....used for Endoworks equipment only) **see report   Inter-facility Information This is not an inter-facility consult request.  Status:                COMPLETE Last Action:           COMPLETE/UPDATE  Facility  Activity                Date/Time/Zone      Responsible Person  Entered By -------------------------------------------------------------------------------  CPRS RELEASED ORDER     02/09/11 07:22      CHALMERS,BONITA     KRUEGER,CORINNE L  INCOMPLETE RPT          02/09/11 10:26                          SHOLLER,WILMER      Note# 4702953  COMPLETE/UPDATE         02/09/11 10:00      CLINICAL,DEVICE P   SHURMAN,JILLIAN A                (entered) 02/09/11 11:00          Note# 4702953  Note: TIME ZONE is local if not indicated  --------------------------------------------------------------------------------   LOCAL TITLE: CP COLONOSCOPY                                      STANDARD TITLE: GASTROENTEROLOGY PROCEDURE NOTE                  DATE OF NOTE: FEB 09, 2011@10:25:46  ENTRY DATE: FEB 09, 2011@10:25:46             AUTHOR: CLINICAL,DEVICE PRO  EXP COSIGNER:                                 URGENCY:                            STATUS: COMPLETED                       PROCEDURE SUMMARY CODE: Machine Resulted               DATE/TIME PERFORMED: FEB 09, 2011@10:00    ** DOCUMENT IN VISTA IMAGING ** SEE FULL REPORT IN VISTA IMAGING  SIGNATURE NOT REQUIRED SEE SIGNATURE IN VISTA IMAGING  ** (OLYMPUS Colonoscopy)  AUTO-INSTRUMENT DIAGNOSIS **  Procedure: Col  Colonoscopy  Release Status: Released Off-Line Verified Date Verified: Feb 09, 2011@10:11  Indications: Surveillance of prior high grade adenoma (V12.72).   Consent: The benefits, risks, and alternatives to the procedure were  discussed and informed consent was obtained from the patient.   Preparation:  EKG, pulse, pulse oximetry and blood pressure were monitored  throughout the procedure. The patient received PEG in preparation for the  procedure. ASA Classification: Class 3 - Patient has severe systemic  disturbance that may or may not be related to the disorder requiring  surgery.   Medications: Versed 2 mg IV   Rectal Exam: Normal rectal exam.   Procedure:  The endoscope was passed with ease through the anus under  direct visualization and advanced to the cecum, confirmed by appendiceal  orifice and ileocecal valve. The scope was withdrawn and the mucosa was  carefully examined. The quality of the preparation was good. The views  were good. The patient's toleration of the procedure was good.Retroflexion was performed in the rectum.Findings:  There was evidence of diverticulosis in the sigmoid colon.On retroflexed view, internal hemorrhoids were found in the rectum.There  was evidence of prior colectomy in the colon.   Unplanned Events:  There were no unplanned events.Impressions: Diverticulosis (562.10) found in the sigmoid colon.Internal hemorrhoids in the rectum(455.0). Evidence of prior intervention in the colon.Personal history of polyps (V12.72)   Recommendations: Colonoscopy recommended in 5 years.Procedure Codes: 45378: Colonoscopy Version 1, electronically signed by Dr.John Beckman on 02/09/2011 at  10:18.    Administrative Closure: 02/09/2011                     by:                          CP CONSULT PROXY      ================================================================================ ==================================== END ===================================== </mcs_text>
//            <mcs_flagSpecified>false</mcs_flagSpecified>
//          </VIMTVIAEMRgcfpconsultsMultipleResponse>

